var __defProp = Object.defineProperty;
var __getOwnPropDesc = Object.getOwnPropertyDescriptor;
var __decorateClass = (decorators, target, key, kind) => {
  var result = kind > 1 ? void 0 : kind ? __getOwnPropDesc(target, key) : target;
  for (var i = decorators.length - 1, decorator; i >= 0; i--)
    if (decorator = decorators[i])
      result = (kind ? decorator(target, key, result) : decorator(result)) || result;
  if (kind && result) __defProp(target, key, result);
  return result;
};
import { atom, computed } from "@tldraw/state";
import { defaultUserPreferences } from "../../config/TLUserPreferences.mjs";
class UserPreferencesManager {
  constructor(user, inferDarkMode) {
    this.user = user;
    this.inferDarkMode = inferDarkMode;
    if (typeof window === "undefined" || !("matchMedia" in window)) return;
    const darkModeMediaQuery = window.matchMedia("(prefers-color-scheme: dark)");
    if (darkModeMediaQuery?.matches) {
      this.systemColorScheme.set("dark");
    }
    darkModeMediaQuery?.addEventListener("change", (e) => {
      if (e.matches) {
        this.systemColorScheme.set("dark");
      } else {
        this.systemColorScheme.set("light");
      }
    });
  }
  systemColorScheme = atom("systemColorScheme", "light");
  updateUserPreferences = (userPreferences) => {
    this.user.setUserPreferences({
      ...this.user.userPreferences.get(),
      ...userPreferences
    });
  };
  getUserPreferences() {
    return {
      id: this.getId(),
      name: this.getName(),
      locale: this.getLocale(),
      color: this.getColor(),
      animationSpeed: this.getAnimationSpeed(),
      isSnapMode: this.getIsSnapMode(),
      colorScheme: this.user.userPreferences.get().colorScheme,
      isDarkMode: this.getIsDarkMode(),
      isWrapMode: this.getIsWrapMode(),
      isDynamicResizeMode: this.getIsDynamicResizeMode()
    };
  }
  getIsDarkMode() {
    switch (this.user.userPreferences.get().colorScheme) {
      case "dark":
        return true;
      case "light":
        return false;
      case "system":
        return this.systemColorScheme.get() === "dark";
      default:
        return this.inferDarkMode ? this.systemColorScheme.get() === "dark" : false;
    }
  }
  getEdgeScrollSpeed() {
    return this.user.userPreferences.get().edgeScrollSpeed ?? defaultUserPreferences.edgeScrollSpeed;
  }
  getAnimationSpeed() {
    return this.user.userPreferences.get().animationSpeed ?? defaultUserPreferences.animationSpeed;
  }
  getId() {
    return this.user.userPreferences.get().id;
  }
  getName() {
    return this.user.userPreferences.get().name ?? defaultUserPreferences.name;
  }
  getLocale() {
    return this.user.userPreferences.get().locale ?? defaultUserPreferences.locale;
  }
  getColor() {
    return this.user.userPreferences.get().color ?? defaultUserPreferences.color;
  }
  getIsSnapMode() {
    return this.user.userPreferences.get().isSnapMode ?? defaultUserPreferences.isSnapMode;
  }
  getIsWrapMode() {
    return this.user.userPreferences.get().isWrapMode ?? defaultUserPreferences.isWrapMode;
  }
  getIsDynamicResizeMode() {
    return this.user.userPreferences.get().isDynamicSizeMode ?? defaultUserPreferences.isDynamicSizeMode;
  }
  getIsPasteAtCursorMode() {
    return this.user.userPreferences.get().isPasteAtCursorMode ?? defaultUserPreferences.isPasteAtCursorMode;
  }
}
__decorateClass([
  computed
], UserPreferencesManager.prototype, "getUserPreferences", 1);
__decorateClass([
  computed
], UserPreferencesManager.prototype, "getIsDarkMode", 1);
__decorateClass([
  computed
], UserPreferencesManager.prototype, "getEdgeScrollSpeed", 1);
__decorateClass([
  computed
], UserPreferencesManager.prototype, "getAnimationSpeed", 1);
__decorateClass([
  computed
], UserPreferencesManager.prototype, "getId", 1);
__decorateClass([
  computed
], UserPreferencesManager.prototype, "getName", 1);
__decorateClass([
  computed
], UserPreferencesManager.prototype, "getLocale", 1);
__decorateClass([
  computed
], UserPreferencesManager.prototype, "getColor", 1);
__decorateClass([
  computed
], UserPreferencesManager.prototype, "getIsSnapMode", 1);
__decorateClass([
  computed
], UserPreferencesManager.prototype, "getIsWrapMode", 1);
__decorateClass([
  computed
], UserPreferencesManager.prototype, "getIsDynamicResizeMode", 1);
__decorateClass([
  computed
], UserPreferencesManager.prototype, "getIsPasteAtCursorMode", 1);
export {
  UserPreferencesManager
};
//# sourceMappingURL=UserPreferencesManager.mjs.map
